
#include <math.h>
#include "my.h"

CSharedV::CSharedV()
{
	m_nType = stUndefined;
	m_pOwner = 0;
	m_sName = "";

	m_nIntValue = -1;
	m_fFloatValue = -1.0f;
	m_sStringValue = "EMPTY_STRING";
}

CSharedV::~CSharedV()
{
	for( QHash<QString,CSharedV*>::iterator i = propBegin(); i != propEnd(); ++i )
		delete i.value();
}

QString CSharedV::asDebugString() const
{
	QString result;
	switch ( getType() )
	{
	case (stUndefined):
		{
			result = "stUndefined";
			break;
		};
	case (stInt):
		{
			result = "stInt == " + QString::number( asInt() );
			break;
		};
	case (stFloat):
		{
			result = "stFloat == " + QString::number( asFloat(), 'f', 3 );
			break;
		};
	case (stString):
		{
			result = "stString == " + asString();
			break;
		};

	case (stObject):
		{
			result = "stObject";
			break;
		};
	default: break;
	};
	return result;
};

void CSharedV::change( int nID, bool bMultiChange )
{	
 //
}

int CSharedV::indexOf(const CSharedV *v) const 
{
	if (v) {	
		QHash<QString,CSharedV*>::const_iterator it = propBegin();
		int idx = 0;
		while (it != propEnd()) {
			if (it.value() == v) {
				return idx;
			}
			++idx;
			++it;
		}
	}
	return -1;
}