#include <QtGui/QStandardItemModel>
#include <QtGui/QTableView>
#include <QtGui/QHeaderView>

#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    model = new QStandardItemModel(5, 2);
    tableView = new QTableView();
    delegate = new TextEditDelegate();

    for (int row = 0; row < 5; ++row) {
        for (int column = 0; column < 2; ++column) {
            QModelIndex index = model->index(row, column, QModelIndex());
            switch(column)
            {
            case 0:
                model->setData(index, QVariant(
                        row+1)); break;
            default:
                switch(row)
                {
                case 0:
                    model->setData(index, QVariant(
                            "")); break;
                case 1:
                    model->setData(index, QVariant(
                            ""
                            "  PRIVETPRIVET 1 01234"
                            "  PRIVET 2 01234"
                            "  PRIVET 3 01234"
                            "  PRIVET 4 01234")); break;
                case 2:
                    model->setData(index, QVariant(
                            "PRIVET PRIVET 1 01234"
                            "  "
                            "  PRIVET 2 01234"
                            "  PRIVET 3 01234"
                            "  PRIVET 4 01234")); break;
                case 3:
                    model->setData(index, QVariant(
                            ""
                            "  PRIVETPRIVET 1 01234"
                            "  PRIVET 2 01234"
                            "  PRIVET 3 01234")); break;
                default:
                    model->setData(index, QVariant(
                            ""
                            "  PRIVETPRIVET 1 01234"
                            "  PRIVET 2 01234"
                            "  PRIVET 3 01234"
                            "  PRIVET 4 01234")); break;
                }
                break;
            }
        }
    }

    tableView->setModel(model);
    tableView->setItemDelegateForColumn(1, delegate);
    tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    tableView->setSelectionMode(QAbstractItemView::SingleSelection);
    tableView->setSelectionBehavior(QAbstractItemView::SelectRows);

    tableView->resizeColumnToContents(0);
    tableView->horizontalHeader()->setStretchLastSection(true);

    tableView->verticalHeader()->hide();
    tableView->verticalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    //tableView->setTextElideMode(Qt::ElideNone);

    if (model->rowCount() > 0)
        tableView->setCurrentIndex(model->index(0, 0));

    setCentralWidget(tableView);

    setWindowTitle("Text Edit Delegate");
    setGeometry(100, 250, 170, 500);
}

MainWindow::~MainWindow()
{

}
