#ifndef QCONTEXTKEYBOARD_H
#define QCONTEXTKEYBOARD_H

#include <QtGui/QInputContext>
#include "qkeyboard.h"

class QContextKeyboard : public QInputContext
{
    Q_OBJECT
public:
    explicit QContextKeyboard(QObject *parent = 0);
    ~QContextKeyboard();
    bool filterEvent(const QEvent* event);

    QString identifierName();
    QString language();

    bool isComposing() const;

    void reset();

private slots:
    void sendCharacter(QChar character);

private:
    void updatePosition();

private:
    QKeyboard *Keyboard;
};

#endif // QCONTEXTKEYBOARD_H
