#include "widget.h"

Widget::Widget(QWidget *parent) : QWidget(parent){
    QVBoxLayout *mainLay = new QVBoxLayout(this);

    mainLay->addWidget(theFirstEdit = new QLineEdit);
    mainLay->addWidget(theSecondEdit = new QLineEdit);
    mainLay->addWidget(theThirdEdit = new QLineEdit);

    theFirstEdit->setInputMask("9999");
    theSecondEdit->setInputMask("9999");
    theThirdEdit->setReadOnly(true);

    QPushButton *clickMeBtn = new QPushButton("Calculate");
    QObject::connect(clickMeBtn, SIGNAL(clicked()), this, SLOT(calculate()));
    mainLay->addWidget(clickMeBtn);
}

Widget::~Widget(){

}

void Widget::calculate(){
    theThirdEdit->setText(QString::number(theFirstEdit->text().toInt() * theSecondEdit->text().toInt()));
}
