#ifndef GRAPHICSSCENE_H
#define GRAPHICSSCENE_H

#include <QGraphicsScene>
#include <QObject>

class GraphicsScene : public QGraphicsScene
{
  Q_OBJECT

public:
  GraphicsScene(QObject *parent = 0);
  int newStep();

public slots:
  void setPos(int value);

signals:
  void needStep();

private:
  int wCells;
  const int gridSize;
  QPen pen;
  QList<int> points;
  QList<QGraphicsLineItem *> allLinesList;

protected:
  void drawBackground(QPainter *painter, const QRectF &rect);
};

#endif // GRAPHICSSCENE_H
