#include <QVarLengthArray>
#include <QtDebug>
#include <QPainter>
#include <QGraphicsLineItem>

#include "graphicsscene.h"

GraphicsScene::GraphicsScene(QObject *parent) :
  QGraphicsScene(parent),
  gridSize( 20 ),
  wCells( 0 ),
  pen(Qt::black, 2.0)
{
}

void GraphicsScene::drawBackground(QPainter *painter, const QRectF &rect)
{
  wCells = 0;

  qreal left = int(rect.left()) - (int(rect.left()) % gridSize);
  qreal top = int(rect.top()) - (int(rect.top()) % gridSize);

  QVarLengthArray<QLineF, 10> lines;

  for (qreal x = left + gridSize; x < rect.right(); x += gridSize, wCells++) {
	lines.append(QLineF(x, rect.top(), x, rect.bottom() - gridSize));
	painter->drawText(x - gridSize / 2,rect.height() - 5,"10");
  }

  qDebug()<<wCells;

  for (qreal y = top; y < rect.bottom() - gridSize; y += gridSize) {
	lines.append(QLineF(rect.left() + gridSize, y, rect.right(), y));
	painter->drawText(0,y+5,"10");
  }

  for (int i = allLinesList.count(); i < wCells+1; ++i) {
	allLinesList.append(new QGraphicsLineItem );
	addItem(allLinesList.last());
  }


	if (allLinesList.count() > wCells) {
	  for (int i = wCells; i < allLinesList.count(); ++i) {

		removeItem(allLinesList.last());
		allLinesList.removeLast();
	  }
  } else if (allLinesList.count() < wCells) {
	  for (int c = 0; c < wCells; ++c) {
		allLinesList.append(new QGraphicsLineItem);
		addItem(allLinesList.last());
	  }
	}

  //qDebug()<<"lines count"<<allLinesList.count();

  painter->drawLines(lines.data(), lines.size());
}

void GraphicsScene::setPos(int value)
{
  if (value != 0) {
	  for (int i = 1; i < allLinesList.count(); ++i) {
		//allLinesList.at(i)->setLine(graphLine.at(i+value,value));

		if (value+i < points.count()) {
		  allLinesList.at(i)->setLine(QLineF(gridSize*(i-1)+gridSize,
													points.at(i+value-1),
													gridSize*i+gridSize,
													points.at(i+value)));

		  allLinesList.at(i)->setPen(QPen(Qt::black,2.0));
		}
	  }
	}
}

int GraphicsScene::newStep()
{

  if (points.isEmpty())
	points.append(qrand() % (int)height());

  points.append(qrand() % ((int)height()-gridSize));

  if (points.count() < wCells) {
	for (int i = 1; i < points.count(); ++i) {
	  allLinesList.at(i)->setLine(QLineF(gridSize*(i),
												points.at(i-1),
												gridSize*(i+1),
												points.at(i)));
	  allLinesList.at(i)->setPen(pen);
	}
  }

  if (points.count() > wCells)
	emit needStep();

  //qDebug()<<"steps avialble"<<points.count();

  int tempVal = 0;
  if (points.count()-wCells > 0)
	tempVal = points.count()-wCells;

  return tempVal;
}
