#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QScrollBar>
#include <QGraphicsLineItem>

#include "graphicsscene.h"
#include "ui_graphics.h"

class MainWindow : public QMainWindow, private Ui::MainWindow
{
  Q_OBJECT

public:
  MainWindow(QWidget *parent = 0);

private:
  QTimer* drawTimer;
  QGraphicsLineItem *vLine;
  GraphicsScene *scene1;
  GraphicsScene *scene2;
  GraphicsScene *scene3;
  GraphicsScene *scene4;
  GraphicsScene *scene5;
  GraphicsScene *scene6;
  GraphicsScene *scene7;
  GraphicsScene *scene8;

private slots:
  void on_btnStart_clicked();
  void drawTimer_timeout();
  void on_progressBar_valueChanged(int value);
  void moveBar();

protected:
   bool eventFilter(QObject *obj, QEvent *event);
   void resizeEvent(QResizeEvent *e);
};

#endif // MAINWINDOW_H

