#include <QtDebug>
#include <QDateTime>
#include <QMouseEvent>
#include <QFile>
#include <QDate>

#include "graphics.h"

MainWindow::MainWindow(QWidget *parent) :
  QMainWindow(parent)
{
  setupUi(this);

  //QDate date = QDate::currentDate();
  //qDebug()<<"date.dayOfYear()"<<date.dayOfYear();

  qsrand(QDateTime::currentDateTime().toTime_t());

  drawTimer = new QTimer(this);
  connect(drawTimer,SIGNAL(timeout()),this,SLOT(drawTimer_timeout()));

//  QPen rpen(Qt::red, 2.0);
//  vLine = new QGraphicsLineItem;
//  vLine->setLine(0,0,0,scene->height());
//  vLine->setPen(rpen);

  scene1 = new GraphicsScene( this );
//  graphicsView->viewport()->setMouseTracking(true);
//  graphicsView->viewport()->installEventFilter(this);
  graphicsView->setCacheMode(QGraphicsView::CacheBackground);
  graphicsView->setScene(scene1);

  scene2 = new GraphicsScene( this );
//  graphicsView_2->viewport()->setMouseTracking(true);
//  graphicsView_2->viewport()->installEventFilter(this);
  graphicsView_2->setCacheMode(QGraphicsView::CacheBackground);
  graphicsView_2->setScene(scene2);

  scene3 = new GraphicsScene( this );
  scene4 = new GraphicsScene( this );

  progressBar->setMaximum(0);
  progressBar->setSingleStep(1);
  progressBar->setValue(0);

  connect(progressBar,SIGNAL(valueChanged(int)),this,SLOT(on_progressBar_valueChanged(int)));

  //connect(scene,SIGNAL(needStep()),this,SLOT(moveBar()));
  connect(scene2,SIGNAL(needStep()),this,SLOT(moveBar()));
}

void MainWindow::on_btnStart_clicked()
{
  if (drawTimer->isActive()) {
	drawTimer->stop();
	btnStart->setText("Start");
  } else {
	drawTimer->start(200);
	progressBar->setValue(progressBar->maximum());
	btnStart->setText("Stop");
  }
}
void MainWindow::drawTimer_timeout()
{
  scene1->newStep();
  progressBar->setMaximum(scene2->newStep());
}

void MainWindow::on_progressBar_valueChanged(int value)
{
  scene1->setPos(value);
  scene2->setPos(value);
}

bool MainWindow::eventFilter(QObject *obj, QEvent *event)
{
  if (event->type() == QEvent::MouseMove) {
	QMouseEvent *mEvent = static_cast<QMouseEvent*>(event);
	int x = mEvent->pos().x();

	if (drawTimer->isActive()) {
	  vLine->hide();
	} else {
	  if (vLine->isVisible())
		vLine->setPos(x,0);
	  else
		vLine->show();
	}

	//int pos = vLine->x()/step;

//    if (allLinesList.at(0)->count()>pos) {

//      lblValue->setText("Temperature = "+QString::number(
//                        graphLine.at(0)->heightAtPos(allLinesList.at(0)->at(pos)->line(),vLine->x())));
//      lblHumidity->setText("Humidity = "+QString::number(
//                           graphLine.at(1)->heightAtPos(allLinesList.at(1)->at(pos)->line(),vLine->x())));
//    } else {
//      lblValue->setText("Temperature = 0");
//      lblHumidity->setText("Humidity = 0");
//    }
	return true;
  } else {
	return false;
  }
  return QMainWindow::eventFilter(obj, event);
}

void MainWindow::resizeEvent(QResizeEvent *e)
{
  scene1->setSceneRect(0,0,graphicsView->width(),graphicsView->height());
  scene2->setSceneRect(0,0,graphicsView_2->width(),graphicsView_2->height());
  scene3->setSceneRect(0,0,graphicsView_3->width(),graphicsView_3->height());
  scene4->setSceneRect(0,0,graphicsView_4->width(),graphicsView_4->height());
  //graphicsView->setPos(progressBar->value());
}

void MainWindow::moveBar()
{
  progressBar->setMaximum(progressBar->maximum()+1);
  progressBar->setValue(progressBar->value()+1);
}
