#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>

namespace Ui {
    class Widget;
}

class Port;
class QTimer;

class Widget : public QWidget
{
    Q_OBJECT

public:
    explicit Widget(QWidget *parent = 0);
    ~Widget();

private slots:
    void procRead();
    void procControlButtonClick();
    void procSendButtonClick();

    void procActivated();

private:
    Ui::Widget *ui;

    Port *m_port;
    QTimer *m_timer;

    void trace(const QByteArray &data, bool directionRx);
};

#endif // WIDGET_H
