#include "widget.h"
#include "ui_widget.h"

#include "port.h"

#include <QtCore/QTimer>
#include <QtCore/QDebug>

Widget::Widget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Widget)
{
    ui->setupUi(this);
    ui->ioTextEdit->document()->setMaximumBlockCount(100);

    m_port = new Port(this);
    connect(m_port, SIGNAL(readyRead()), this, SLOT(procRead()));

    m_timer = new QTimer(this);
    m_timer->setInterval(1000);
    connect(m_timer, SIGNAL(timeout()), this, SLOT(procSendButtonClick()));

    connect(ui->controlButton, SIGNAL(clicked()), this, SLOT(procControlButtonClick()));
    connect(ui->sendButton, SIGNAL(clicked()), this, SLOT(procSendButtonClick()));

    connect(m_port, SIGNAL(activated(HANDLE)), this, SLOT(procActivated()));
}

Widget::~Widget()
{
    delete ui;
}

enum {
    MAX_PACK_LEN = 256,
    EXPECTED_PACK_LEN = 11
};

static char arr[MAX_PACK_LEN];
static char *ptr = arr;
static int count = 0;

void Widget::procRead()
{
    int ret = m_port->avail();
    if (ret >= 0) {
        ret = qMin(ret, MAX_PACK_LEN - count);
        if (ret >= 0) {
            ret = m_port->recv(ptr, ret);
            if (ret >= 0) {
                count += ret;
                ptr += ret;
            } else {
                count = 0;
                ptr = arr;
            }
        } else {
            count = 0;
            ptr = arr;
        }
    } else {
        count = 0;
        ptr = arr;
    }

    if (count >= EXPECTED_PACK_LEN) {
        QByteArray ba(arr, count);
        trace(ba, true);
        count = 0;
        ptr = arr;

    }
}

void Widget::procControlButtonClick()
{
    m_port->control();
    ui->controlButton->setText(m_port->isOpen() ? tr("Close") : tr("Open"));

}

void Widget::procSendButtonClick()
{
    if (!m_port->isOpen())
        return;

    if (!m_timer->isActive())
        m_timer->start();

    QByteArray ba = QByteArray::fromHex(ui->sendLineEdit->text().toLocal8Bit());
    if (ba.size() > 0) {
        trace(ba, false);
        m_port->send(ba);
    }
}

void Widget::procActivated()
{
    qDebug() << "Signal activated";
}

void Widget::trace(const QByteArray &data, bool directionRx)
{
    ui->ioTextEdit->setTextColor((directionRx) ? Qt::darkBlue : Qt::darkGreen);
    ui->ioTextEdit->append(data.toHex());
}
