#ifndef PORT_H
#define PORT_H

#include <QtCore/private/qwineventnotifier_p.h>
#include <qt_windows.h>

class Port : public QWinEventNotifier
{
    Q_OBJECT
signals:
    void readyRead();

public:
    explicit Port(QObject *parent = 0);
    virtual ~Port();

    void control();
    bool isOpen() const { return (INVALID_HANDLE_VALUE != m_hd); }

public slots:
    void send(const QByteArray &data);
    int recv(char *data, int len);
    int avail() const;

protected:
    bool event(QEvent *e);

private:
    HANDLE m_hd;
    OVERLAPPED m_or;
    OVERLAPPED m_ow;
    OVERLAPPED m_oe;
    DWORD m_setMask;
    DWORD m_currMask;
};

#endif // PORT_H
