#ifndef MYMODEL_H
#define MYMODEL_H

#include <QAbstractItemModel>

class MyItem;

class MyModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    MyModel(QObject *parent = 0);

    QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex &index) const;
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Qt::ItemFlags flags(const QModelIndex &index) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
    QModelIndex buddy(const QModelIndex &index) const;

    MyItem *rootItem() const;
    void setRootItem(MyItem *pRootItem);
    MyItem *getItem(const QModelIndex &index) const;
private:
    MyItem *m_pRootItem;
};

#endif // MYMODEL_H
