#include "mymodel.h"
#include "myitem.h"
#include <QColor>
#include <QPixmap>

MyModel::MyModel(QObject *parent) :
    QAbstractItemModel(parent),
    m_pRootItem(0)
{
}

QModelIndex MyModel::index(int row, int column, const QModelIndex &parent) const
{
    if (!hasIndex(row, column, parent))
        return QModelIndex();

    MyItem *pParentItem = getItem(parent);
    MyItem *pChildProperty = pParentItem->child(row);

    if (pChildProperty)
        return createIndex(row, column, pChildProperty);
    else
        return QModelIndex();
}

QModelIndex MyModel::parent(const QModelIndex &index) const
{
    if (!index.isValid())
        return QModelIndex();

    MyItem *pChildItem = static_cast<MyItem*>(index.internalPointer());
    MyItem *pParentItem = pChildItem->parent();

    if (pParentItem == m_pRootItem)
        return QModelIndex();

    return createIndex(pParentItem->index(), 0, pParentItem);
}

int MyModel::rowCount(const QModelIndex &parent) const
{
    return m_pRootItem ? getItem(parent)->childrenCount() : 0;
}

int MyModel::columnCount(const QModelIndex &/*parent*/) const
{
    return 2;
}

QVariant MyModel::data(const QModelIndex &index, int role) const
{
    if (!index.isValid())
        return QVariant();

    MyItem *pItem = getItem(index);

    if (index.column() == 0)
    {
        if (role == Qt::DisplayRole)
            return  QVariant(pItem->name());
        return QVariant();
    }

    switch (role)
    {
    case Qt::EditRole:
    case Qt::DisplayRole:
        return pItem->value();
    case Qt::DecorationRole:
        {
            QColor color = pItem->value().value<QColor>();
            QPixmap pixmap(16, 16);
            pixmap.fill(color);
            return QVariant::fromValue(pixmap);
        }
    default:
        return QVariant();
    }
}

Qt::ItemFlags MyModel::flags(const QModelIndex &index) const
{
    if (!index.isValid())
        return Qt::NoItemFlags;

    return Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable;
}

QVariant MyModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    if (orientation == Qt::Horizontal && role == Qt::DisplayRole)
    {
        if (section == 0)
            return QVariant("Name");
        else
            return QVariant("Value");
    }
    return QVariant();
}

QModelIndex MyModel::buddy(const QModelIndex &index) const
{
    if (index.isValid() && index.column() == 0)
        return this->index(index.row(), 1, parent(index));
    return index;
}

MyItem *MyModel::rootItem() const
{
    return m_pRootItem;
}

void MyModel::setRootItem(MyItem *pRootItem)
{
    m_pRootItem = pRootItem;
    reset();
}

MyItem *MyModel::getItem(const QModelIndex &index) const
{
    if (index.isValid())
    {
        MyItem *pItem = static_cast<MyItem*>(index.internalPointer());
        if (pItem) return pItem;
    }
    return m_pRootItem;
}
