#ifndef MYITEM_H
#define MYITEM_H

#include <QVariant>
#include <QList>

class MyItem
{
    MyItem *m_parent;
    QList<MyItem*> m_children;
    QVariant m_value;
    QString  m_name;
public:
    MyItem();
    ~MyItem();

    MyItem *parent() const;
    int index() const;
    MyItem *child(int index) const;
    bool addChild(MyItem *item);
    int childrenCount() const;

    QVariant value() const;
    void setValue(const QVariant &value);
    QString name() const;
    void setName(const QString &name);
};

#endif // MYITEM_H
