#include "myitem.h"

MyItem::MyItem():
        m_parent(0)
{
}

MyItem::~MyItem()
{
    qDeleteAll(m_children);
}

MyItem *MyItem::parent() const
{
    return m_parent;
}

int MyItem::index() const
{
    return m_parent ? m_parent->m_children.indexOf(const_cast<MyItem*>(this)) : 0;
}

MyItem *MyItem::child(int index) const
{
    return m_children.value(index);
}

bool MyItem::addChild(MyItem *item)
{
    if (!item || m_children.contains(item))
        return false;
    item->m_parent = this;
    m_children.append(item);
    return true;
}

int MyItem::childrenCount() const
{
    return m_children.count();
}

QVariant MyItem::value() const
{
    return m_value;
}

void MyItem::setValue(const QVariant &value)
{
    m_value = value;
}

QString MyItem::name() const
{
    return m_name;
}

void MyItem::setName(const QString &name)
{
    m_name = name;
}
