#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "myitem.h"
#include "mymodel.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    init();
}

MainWindow::~MainWindow()
{
    delete ui;
    delete m_rootItem;
}

void MainWindow::init()
{
    m_rootItem = new MyItem();

    MyItem *item = new MyItem();
    item->setName(QString("RED"));
    item->setValue(QColor(255, 0, 0));
    m_rootItem->addChild(item);

    item = new MyItem();
    item->setName(QString("GREEN"));
    item->setValue(QColor(0, 255, 0));
    m_rootItem->addChild(item);

    item = new MyItem();
    item->setName(QString("BLUE"));
    item->setValue(QColor(0, 0, 255));
    m_rootItem->addChild(item);

    m_model = new MyModel(this);
    m_model->setRootItem(m_rootItem);
    ui->treeView->setModel(m_model);
}
