#include "mainwindow.h"
#include <QtDeclarative/QtDeclarative>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    translator(0)
{
    view = new QDeclarativeView;
    setCentralWidget(view);

    QString fn = "MainWindow.qml";
    QFileInfo fi(fn);
    QUrl url = QUrl::fromLocalFile(fi.absoluteFilePath());

    QString fileName = url.toLocalFile();
    QFileInfo fio(fileName);
    loadTranslationFile(fio.path());

    view->setSource(url);
    view->setResizeMode(QDeclarativeView::SizeRootObjectToView);
}

void MainWindow::loadTranslationFile(const QString& directory)
{
    if (!translator) {
        translator = new QTranslator(this);
        translator->load(QLatin1String("qml_" )+QLocale::system().name(), directory + QLatin1String("/i18n"));
        QApplication::installTranslator(translator);
    }
}
