#ifndef SOCKETS_H
#define SOCKETS_H

#include <QTcpSocket>

#include <QBitArray>
#include <QList>
#include <QTcpSocket>

QT_BEGIN_NAMESPACE
class QHostAddress;
class QTimerEvent;
QT_END_NAMESPACE

class KTcpSocket : public QTcpSocket
{
    Q_OBJECT

public:
    KTcpSocket(QObject *parent = 0);

    inline bool canReadLine() const { return incomingBuffer.indexOf('\n') != -1 || socket.canReadLine(); }
	
    // Rate control
    qint64 writeToSocket(qint64 bytes);
    qint64 readFromSocket(qint64 bytes);
    qint64 downloadSpeed() const;
    qint64 uploadSpeed() const;

    bool canTransferMore() const;
    qint64 bytesAvailable() const { return incomingBuffer.size() + QTcpSocket::bytesAvailable(); }
    qint64 socketBytesAvailable() const { return socket.bytesAvailable(); }
    qint64 socketBytesToWrite() const { return socket.bytesToWrite(); }

    void setReadBufferSize(int size);

signals:
    void readyToTransfer();
    void bytesReceived(qint64 size);

protected slots:
    void connectToHostImplementation(const QString &hostName, quint16 port, OpenMode openMode = ReadWrite);
    void diconnectFromHostImplementation();

protected:
    void timerEvent(QTimerEvent *event);

    qint64 readData(char *data, qint64 maxlen);
    qint64 readLineData(char *data, qint64 maxlen);
    qint64 writeData(const char *data, qint64 len);

private:
    // Data waiting to be read/written
    QByteArray incomingBuffer;
    QByteArray outgoingBuffer;

    // Upload/download speed records
    qint64 uploadSpeedData[8];
    qint64 downloadSpeedData[8];

    // Timeout handling
    int transferSpeedTimer;

    QTcpSocket socket;
};

#endif // SOCKETS_H
