/****************************************************************************
**
** Copyright (C) 2006 Trolltech AS. All rights reserved.
**
** This file is part of the documentation of Qt. It was originally
** published as part of Qt Quarterly.
**
** This file may be used under the terms of the GNU General Public License
** version 2.0 as published by the Free Software Foundation or under the
** terms of the Qt Commercial License Agreement. The respective license
** texts for these are provided with the open source and commercial
** editions of Qt.
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "ratecontroller.h"
#include "sockets.h"

#include <QtCore/QCoreApplication>
#include <QtCore/QDebug>

class Foo : public QObject
{
    Q_OBJECT
public slots:
    void showData()
    {
        KTcpSocket *socket = (KTcpSocket *)sender();
        while (socket->canReadLine())
            qDebug() << socket->readLine();
    }
	
    void onExit()
	{
        KTcpSocket *socket = (KTcpSocket *)sender();
		
		qDebug() << "bytesAvailable: " << socket->bytesAvailable();
		qDebug() << "socketBytesAvailable: " << socket->socketBytesAvailable();
		qDebug() << "canReadLine: " << socket->canReadLine();
		qDebug() << "socketCanReadLine: " << socket->QTcpSocket::canReadLine();
	}
};

int main(int argc, char **argv)
{
    QCoreApplication app(argc, argv);

    KTcpSocket socket;
    socket.connectToHost("qt.nokia.com", 80);
    socket.write("GET / HTTP/1.0\r\n\r\n");

    RateController::instance()->setUploadLimit(2048);
    RateController::instance()->setDownloadLimit(2048);
    RateController::instance()->addSocket(&socket);

    Foo foo;

    QObject::connect(&socket, SIGNAL(readyRead()), &foo, SLOT(showData()));
    QObject::connect(&socket, SIGNAL(readChannelFinished()), &foo, SLOT(onExit()));
    //QObject::connect(&socket, SIGNAL(readChannelFinished()), &app, SLOT(exit()));

    return app.exec();
}

#include "main.moc"

