#include "yaction.h"

#include <QMenu>
#include <QMenuBar>

//YAction::YAction(const QString &text) :
//	QAction()
//{

//}

YAction::YAction(const QString &text, QAction *action)
	:QAction(text, action)
{
	m_parentAction = action;
	//    , 
	//      
	YAction *a = qobject_cast<YAction *>(action);
	if (a)
		a->m_childActions << this;

	//    ,   
	//   
	QMenu *m = action->menu();
	if (m){
		m->addAction(this);
	}else{
		m = new QMenu(this->text());
		m->addAction(this);
		action->setMenu(m);
	}
}


YAction::YAction(const QString &text, QMenu *menu)
	:QAction(text, menu)
{
	m_parentAction = menu->menuAction();
	menu->addAction(this);
}

YAction::YAction(const QString &text, QMenuBar *menuBar)
	:QAction(text, menuBar)
{
	m_parentAction = 0;
	menuBar->addAction(this);
}

QAction *YAction::parentAction()
{
	return m_parentAction;
}

QList<QAction *> YAction::childActions() const
{
	return m_childActions;
}

void YAction::addChildAction(QAction *action)
{
	m_childActions << action;
}
