#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QToolButton>

#include "ui_mainwindow.h"

class Button : public QToolButton
{
    Q_OBJECT

    //создаем класс создания кнопки
    public:
        Button(const QString &text, QWidget *parent = 0);
};

class MainWindow : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

    public:
        MainWindow(QWidget *parent = 0);

    protected:
        void resizeEvent(QResizeEvent *e );

    //действие производимое нажатой клавиши
    private slots:
        void buttonClicked();

    private:
        Button *createButton(const QString &text, const char *member, int &num);
        enum { NumButtons = 100 };
        Button *Buttons1[NumButtons];
        Button *Buttons2[NumButtons];
};

#endif // MAINWINDOW_H
