#include <QApplication>
#include <QtGui>
#include <QCursor>

#include "mainwindow.h"
#include "ui_mainwindow.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    MainWindow w;
    w.show();
    return app.exec();
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setupUi(this);

    int my=height()/40;
    setGeometry(pos().x(), pos().y(), width(), height()-(height()-my*40)+2);

    table->setGeometry(0,0,width(),height());
    table->setColumnCount(3);
    table->setRowCount(55);
    //это почемуто не пашит, только после нажатия любой кнопки срабатывает
    //QScrollBar *bar = table->verticalScrollBar();
    //bar->setPageStep(1);

    //создаем массивы кнопок
    for (int i = 1; i < NumButtons; i++)
    {
        Buttons1[i] = createButton("Up", SLOT(buttonClicked()),i);
        Buttons2[i] = createButton("Down", SLOT(buttonClicked()),i);
    }

    //заполняем кнопками ячейки таблици
    for (int i = 0; i < NumButtons; i++)
    {
        table->setCellWidget(i-1, 1, Buttons1[i]);
        table->setCellWidget(i-1, 2, Buttons2[i]);
    }

    table->setColumnWidth(1,40);
    table->setColumnWidth(2,40);
    table->setRowHeight(0,40);

    //заполняем первый столбец числами
    for (int i = 0; i < table->rowCount(); i++)
    {
        QTableWidgetItem* itemText = new QTableWidgetItem();
        itemText->setText(QString::number(i+1));
        table->setItem(i, 0, itemText);
    }
}

Button::Button(const QString &text, QWidget *parent)
    : QToolButton(parent)
{
    setText(text);
}

void MainWindow::buttonClicked()
{
    //в эту функцию не вникал, мне гланое что пашит так как надо
    Button *clickedButton = qobject_cast<Button *>(sender());
    QString value = clickedButton->text();
    setWindowTitle("You click button: " + value + " " + clickedButton->accessibleName());

    int nowClicked=clickedButton->accessibleName().toInt()-1;

    QString temp;
    QString clickedText;
    QScrollBar *bar = table->verticalScrollBar();
    bar->setPageStep(1);

    if (clickedButton->text()=="Up" && nowClicked!=0)
    {
        clickedText = table->item(nowClicked, 0)->text();
        temp = table->item(nowClicked-1, 0)->text();
        QTableWidgetItem* item1 = new QTableWidgetItem();
        QTableWidgetItem* item2 = new QTableWidgetItem();
        item1->setText(temp);
        table->setItem(nowClicked, 0, item1);
        item2->setText(clickedText);
        table->setItem(nowClicked-1, 0, item2);
        if (bar->value()!=nowClicked)
        {
            QPoint my=QCursor::pos();
            int xt=my.x(), yt=my.y();
            QCursor::setPos(xt, yt-40);
        }
        else
            bar->setValue(nowClicked-1);
    }

    if (clickedButton->text()=="Down" && nowClicked!=table->rowCount()-1)
    {
        clickedText = table->item(nowClicked, 0)->text();
        temp = table->item(nowClicked+1, 0)->text();
        QTableWidgetItem* item1 = new QTableWidgetItem();
        QTableWidgetItem* item2 = new QTableWidgetItem();
        item1->setText(temp);
        table->setItem(nowClicked, 0, item1);
        item2->setText(clickedText);
        table->setItem(nowClicked+1, 0, item2);

        if (bar->value()!=nowClicked-(height()/40)+1)
        {
            QPoint my=QCursor::pos();
            int xt=my.x(), yt=my.y();
            QCursor::setPos(xt, yt+40);
        }
        else
            bar->setValue(bar->value()+1);
    }
}

Button *MainWindow::createButton(const QString &text, const char *member, int &num)
{
    Button *button = new Button(text);
    button->setAccessibleName(QString::number(num));
    connect(button, SIGNAL(clicked()), this, member);
    return button;
}

void MainWindow::resizeEvent(QResizeEvent *e)
{
    table->setGeometry(0, 0, width(), height());
    table->setColumnWidth(0, width()-45-table->columnWidth(1)*2);
    int my=height()/40;
    setGeometry(pos().x(), pos().y(), width(), height()-(height()-my*40)+2);
}
