#include <QtCore/QtGlobal>
#include <QtCore/QtDebug>

#include <QtCore/QTimer>

#include <QtCore/QTime>

#include <QtCore/QVector>
#include <QtCore/QThread>
#include <QtCore/QtConcurrentMap>
#include <QtCore/QtConcurrentFilter>
#include <QtCore/QCoreApplication>

#include <algorithm>

#include "call_once.h"

enum {Max = 100};

struct run_once
{
    void operator()()
    {
        qDebug() << "Functor: This only once...";
    }
};

void func_run_once()
{
    qDebug() << "Function: This only once...";
}

struct inc_functor
{
    inc_functor() : counter(0) {}
    inline int operator()() {return counter++;}
    int counter;
};

struct setPriorityFunctor
{
    setPriorityFunctor(QThread::Priority priority = QThread::NormalPriority)
        : m_priority(priority) {}
    inline void operator()()
    {
        QThread* thread = QThread::currentThread();
        thread->setPriority(m_priority);
    }
    QThread::Priority m_priority;
};

void setLowestPriorityFunction()
{
    QThread* thread = QThread::currentThread();
    thread->setPriority(QThread::LowestPriority);

    qDebug("Current thread %x. Thread set to Lowest priority",
           (quintptr)thread);
}

void setHighestPriorityFunction()
{
    QThread* thread = QThread::currentThread();
    thread->setPriority(QThread::HighestPriority);

    qDebug("Current thread %x. Thread set to Highest priority",
           (quintptr)thread);
}

int calculate(const int& num)
{
#if 0 // Test once call per thread with function
    #if 0 // Set lowest thread priority
        qCallOncePerThread(setLowestPriorityFunction);
    #else // Set highest thread priority
        qCallOncePerThread(setHighestPriorityFunction);
    #endif
#else // Test once call per thread with functor
    #if 0
        qCallOncePerThread(setPriorityFunctor(QThread::HighestPriority));
    #else
        qCallOncePerThread(setPriorityFunctor(QThread::LowestPriority));
    #endif
#endif

    return ~num;
}

static QBasicAtomicInt flag = Q_BASIC_ATOMIC_INITIALIZER(CallOnce::CO_Request);

int parityFilter(const int& num)
{
    qCallOnce(run_once(), flag);

    return num % 2 ? false : true;
}

static QBasicAtomicInt testflag = Q_BASIC_ATOMIC_INITIALIZER(CallOnce::CO_Request);

int main(int argc, char* argv[])
{
    QCoreApplication a(argc, argv);

    QTime t; t.start();
    for (int i = 0; i < 1000 * 1000 * 100; ++i)
        qCallOnce(run_once(), testflag);
    qDebug("%d ms", t.elapsed());

    QVector<int> ints;

    std::generate_n(std::back_insert_iterator<QVector<int> >(ints),
                                                (int)Max, inc_functor());

// Test qCallOnce
    {
        QVector<int> results = QtConcurrent::blockingMapped(ints, calculate);
        qDebug() << results;
    }

// Test qCallOncePerThread
    {
        QtConcurrent::blockingFilter(ints, parityFilter);
        qDebug() << ints;
    }

    return 0;
}

