// property sheet by QCasper (Anton I Alferov)

#include "../include/propertysheet.h"
#include <qheaderview.h>

#include <qtranslator.h>
#include <qapplication.h>
#include <qpainter.h>
#include <QLinearGradient>
#include <QMouseEvent>

void PlusMinusWg::paintEvent(QPaintEvent *) {
	QPainter p(this);
	p.setPen(QPen(QColor(m_BgColor)));
	p.setBrush(m_BgColor);
	p.drawRect(rect());

	p.setPen(QPen(QColor(142,153,125)));

	QLinearGradient lg(m_PMRect.topLeft(), m_PMRect.bottomRight());
	lg.setColorAt(0,QColor(255,255,255));
	lg.setColorAt(1,QColor(195,186,170));
	p.setBrush(lg);

	p.drawRoundRect(m_PMRect, 50, 50);

	int l = 6*m_PMRect.width()/7;
	p.setPen(QPen(QColor(0,0,0)));
	p.drawLine(m_PMRect.x()+l, m_PMRect.center().y()+1,
		m_PMRect.x() + m_PMRect.width()-l, m_PMRect.center().y()+1);
	if (m_Closed)
		p.drawLine(m_PMRect.center().x()+1, m_PMRect.y()+l,
		m_PMRect.center().x()+1, m_PMRect.y() + m_PMRect.height() - l);
}
void PlusMinusWg::resizeEvent(QResizeEvent *) {
	int h = rect().height(); // widget height
	int rs = h/2;		// plus-minus rect side length
	int d = (h-rs)/2;	// plus-minus distance from widget top left

	m_PMRect.setSize(QSize(rs, rs));
	m_PMRect.moveTopLeft(QPoint(d, d));
}
void PlusMinusWg::mousePressEvent(QMouseEvent *e) {
	if ((e->button() == Qt::LeftButton) && (m_PMRect.contains(e->pos()))) {
		m_Closed = !m_Closed;
		emit closed(m_Closed);
		update();
	}
}
void PlusMinusWg::setBgColor(const QColor & color) {
	m_BgColor = color;
}
void PlusMinusWg::open() {
	m_Closed = false;
	emit closed(m_Closed);
	update();
}
void PlusMinusWg::close() {
	m_Closed = true;
	emit closed(m_Closed);
	update();
}

PropertySheet::PropertySheet(QWidget *parent):
QTableWidget(parent),
//m_CaptionColor(QColor(172,168,153)) {
m_CaptionColor(QColor(168,168,168)) {

	setColumnCount(2);
	setSelectionMode(QAbstractItemView::NoSelection);
	setEditTriggers(QAbstractItemView::NoEditTriggers);
	setHorizontalScrollMode(QAbstractItemView::ScrollPerPixel);
	horizontalHeader()->setStretchLastSection(true);
	setAlternatingRowColors(true);
	setTabKeyNavigation(true);
	
	QStringList labels;
	labels << tr("Property") << tr("Value");
	setHorizontalHeaderLabels(labels);

	horizontalHeader()->setClickable(false);
	horizontalHeader()->setResizeMode(1, QHeaderView::Stretch);
	verticalHeader()->hide();
}
int PropertySheet::addRow() {
	int row = rowCount();
	insertRow(row);
	m_RowHeight = static_cast<int>(rowHeight(row) * 0.7);
	setRowHeight(row, m_RowHeight);
	return row;
}
void PropertySheet::addCaption(const QString & name, bool closed) {
	if (name.isEmpty() || m_Captions.contains(name)) return;

	int row = addRow();

	PlusMinusWg *pm = new PlusMinusWg(name, this);
	(closed) ? pm->close() : pm->open();
	m_Captions.insert(name, pm);
	connect(pm, SIGNAL(closed(bool)), this, SLOT(changeCaptionState(bool)));

	pm->setBgColor(m_CaptionColor);
	setCellWidget(row, 0, pm);

	QTableWidgetItem *value= new QTableWidgetItem(name);
	value->setBackgroundColor(m_CaptionColor);

	QFont ft;
	ft.setPointSize(10);
	ft.setBold(true);
	value->setFont(ft);
	value->setTextColor(Qt::white);
	value->setTextAlignment(Qt::AlignCenter);
	setItem(row, 1, value);

	m_LastAddedCaption = name;
}
void PropertySheet::addPropertyWidget(const QString & name, QWidget *widget) {
	if (name.isEmpty()) return;

	int row = addRow();
	QTableWidgetItem *property = new QTableWidgetItem(name);
	setItem(row, 0, property);
	setCellWidget(row, 1, widget);

	if (!m_LastAddedCaption.isEmpty())
		if (m_Captions[m_LastAddedCaption]->isClosed())
			setRowHeight(row, 0);
	m_Rows.insertMulti(m_LastAddedCaption, row);
}
void PropertySheet::changeCaptionState(bool closed) {
	PlusMinusWg *wg = (PlusMinusWg*)sender();
	if (closed)
		foreach(int row, m_Rows.values(wg->name()))
			setRowHeight(row, 0);
	else
		foreach(int row, m_Rows.values(wg->name()))
			setRowHeight(row, m_RowHeight);
}
bool PropertySheet::isCaptionClosed(const QString & name) {
	if (m_Captions.contains(name))
		return m_Captions[name]->isClosed();
	return false;
}
void PropertySheet::setCaptionState(const QString & name, bool closed) {
	if (m_Captions.contains(name))
		(closed) ? m_Captions[name]->close() : m_Captions[name]->open();
}
