// property sheet by QCasper (Anton I Alferov)

#ifndef _PROPERTYSHEET_H_
#define _PROPERTYSHEET_H_

#include <qtablewidget.h>
#include <qmap.h>

class PlusMinusWg;

typedef QMap<QString, PlusMinusWg*> CaptionMap;
typedef QMap<QString, int> RowMap;

class PlusMinusWg : public QWidget {
	Q_OBJECT
public:
	PlusMinusWg(const QString & name, QWidget *parent = 0):
	QWidget(parent),
	m_Name(name),
	m_Closed(false) {}
	virtual ~PlusMinusWg(){}

	void setBgColor(const QColor & color);
	QString name() { return m_Name; }

	void open();
	void close();

	bool isClosed() { return m_Closed; }

signals:
	void closed(bool);

protected:
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);
	void mousePressEvent(QMouseEvent *);

private:
	QColor m_BgColor;
	QRect m_PMRect; // rect where plus-minus control will draw
	QString m_Name;
	bool m_Closed;
};

class PropertySheet : public QTableWidget {
	Q_OBJECT
public:
	PropertySheet(QWidget *parent = 0);
	~PropertySheet(){}

	void addCaption(const QString & name, bool closed = false);
	void addPropertyWidget(const QString & name, QWidget *widget);

	bool isCaptionClosed(const QString & name);
	void setCaptionState(const QString & name, bool closed);
	QStringList captionList() { return m_Captions.keys(); }

private slots:
	void changeCaptionState(bool);

private:
	int addRow();

	RowMap m_Rows;
	CaptionMap m_Captions;

	QColor m_CaptionColor;
	QString m_LastAddedCaption;
	int m_RowHeight;
};

#endif
