#include <QtCore/QCoreApplication>
#include <QtCore/QDebug>

#include "abstractserial.h"

int main(int argc, char *argv[])
{
    QCoreApplication app(argc, argv);

    AbstractSerial *port = new AbstractSerial();

    port->setDeviceName("COM3");

    int cnt = 3;

    while (cnt--) {

        qDebug() << "Cnt = " << cnt;

        if (port->open(AbstractSerial::ReadWrite)) {
            qDebug() << "Serial device " << port->deviceName() << " open in " << port->openMode();

            qDebug() << "= Default parameters =";
            qDebug() << "Device name            : " << port->deviceName();
            qDebug() << "Baud rate              : " << port->baudRate();
            qDebug() << "Data bits              : " << port->dataBits();
            qDebug() << "Parity                 : " << port->parity();
            qDebug() << "Stop bits              : " << port->stopBits();
            qDebug() << "Flow                   : " << port->flowControl();
            qDebug() << "Char timeout, msec     : " << port->charIntervalTimeout();

            if ( port->setBaudRate(AbstractSerial::BaudRate115200) &&
                 port->setDataBits(AbstractSerial::DataBits8) &&
                 port->setParity(AbstractSerial::ParityNone) &&
                 port->setStopBits(AbstractSerial::StopBits1) &&
                 port->setFlowControl(AbstractSerial::FlowControlOff) &&
                 port->setCharIntervalTimeout(50) ) {

                qDebug() << "= New parameters =";
                qDebug() << "Device name            : " << port->deviceName();
                qDebug() << "Baud rate              : " << port->baudRate();
                qDebug() << "Data bits              : " << port->dataBits();
                qDebug() << "Parity                 : " << port->parity();
                qDebug() << "Stop bits              : " << port->stopBits();
                qDebug() << "Flow                   : " << port->flowControl();
                qDebug() << "Char timeout, msec     : " << port->charIntervalTimeout();

                port->close();
                qDebug() << "Serial device " << port->deviceName() << " is closed";
            }
            else {
                qDebug() << "Error set serial device " << port->deviceName();
                break;
            }
        }
        else {
            qDebug() << "Error opened serial device " << port->deviceName();
            break;
        }
    }
    return app.exec();
}
