#include "thread.h"
#include <QProcess>

ServerThread::ServerThread(QObject *parent) : QThread(parent), process(0)
{
}

ServerThread::~ServerThread()
{
    quit();
    wait();
    delete process;
}

void ServerThread::run()
{
    process = new QProcess;
    process->setProcessChannelMode(QProcess::MergedChannels);
    connect(process, SIGNAL(readyReadStandardOutput()), this, SLOT(output()));
    process->start("ping localhost");
    exec();
}
void ServerThread::output()
{
    QByteArray bytes = process->readAllStandardOutput();
    emit updateOutput(bytes);
}
