#include "dialog.h"
#include "ui_dialog.h"
#include "Matrix2D.h"

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
//====================================================================//
//                                A+B=C                               //
//====================================================================//
void Dialog::on_pushButton_Plus_clicked()
{
    Matrix2D Matrix_A(3,3);
    for(int i=0; i<3; i++){
        Matrix_A(i, 0) = ui->tableWidget_MatrixA->item(i,0)->text().toDouble();
        Matrix_A(i, 1) = ui->tableWidget_MatrixA->item(i,1)->text().toDouble();
        Matrix_A(i, 2) = ui->tableWidget_MatrixA->item(i,2)->text().toDouble();
    }

    Matrix2D Matrix_B(3,3);
    for(int i=0; i<3; i++){
        Matrix_B(i, 0) = ui->tableWidget_MatrixB->item(i,0)->text().toDouble();
        Matrix_B(i, 1) = ui->tableWidget_MatrixB->item(i,1)->text().toDouble();
        Matrix_B(i, 2) = ui->tableWidget_MatrixB->item(i,2)->text().toDouble();
    }

    Matrix2D Matrix_C(3,3);
    Matrix_C = Matrix_A + Matrix_B;

    for(int i=0; i<3; i++){
        ui->tableWidget_MatrixC->setItem(i,0,new QTableWidgetItem(QString::number(Matrix_C.Get(i,0))));
        ui->tableWidget_MatrixC->setItem(i,1,new QTableWidgetItem(QString::number(Matrix_C.Get(i,1))));
        ui->tableWidget_MatrixC->setItem(i,2,new QTableWidgetItem(QString::number(Matrix_C.Get(i,2))));
    }
}
//====================================================================//
//                                A-B=C                               //
//====================================================================//
void Dialog::on_pushButton_Minus_clicked()
{
    Matrix2D Matrix_A(3,3);
    for(int i=0; i<3; i++){
        Matrix_A(i, 0) = ui->tableWidget_MatrixA->item(i,0)->text().toDouble();
        Matrix_A(i, 1) = ui->tableWidget_MatrixA->item(i,1)->text().toDouble();
        Matrix_A(i, 2) = ui->tableWidget_MatrixA->item(i,2)->text().toDouble();
    }

    Matrix2D Matrix_B(3,3);
    for(int i=0; i<3; i++){
        Matrix_B(i, 0) = ui->tableWidget_MatrixB->item(i,0)->text().toDouble();
        Matrix_B(i, 1) = ui->tableWidget_MatrixB->item(i,1)->text().toDouble();
        Matrix_B(i, 2) = ui->tableWidget_MatrixB->item(i,2)->text().toDouble();
    }

    Matrix2D Matrix_C(3,3);
    Matrix_C = Matrix_A - Matrix_B;

    for(int i=0; i<3; i++){
        ui->tableWidget_MatrixC->setItem(i,0,new QTableWidgetItem(QString::number(Matrix_C.Get(i,0))));
        ui->tableWidget_MatrixC->setItem(i,1,new QTableWidgetItem(QString::number(Matrix_C.Get(i,1))));
        ui->tableWidget_MatrixC->setItem(i,2,new QTableWidgetItem(QString::number(Matrix_C.Get(i,2))));
    }
}
//====================================================================//
//                                A*B=C                               //
//====================================================================//
void Dialog::on_pushButton_Multi_clicked()
{
    Matrix2D Matrix_A(3,3);
    for(int i=0; i<3; i++){
        Matrix_A(i, 0) = ui->tableWidget_MatrixA->item(i,0)->text().toDouble();
        Matrix_A(i, 1) = ui->tableWidget_MatrixA->item(i,1)->text().toDouble();
        Matrix_A(i, 2) = ui->tableWidget_MatrixA->item(i,2)->text().toDouble();
    }

    Matrix2D Matrix_B(3,3);
    for(int i=0; i<3; i++){
        Matrix_B(i, 0) = ui->tableWidget_MatrixB->item(i,0)->text().toDouble();
        Matrix_B(i, 1) = ui->tableWidget_MatrixB->item(i,1)->text().toDouble();
        Matrix_B(i, 2) = ui->tableWidget_MatrixB->item(i,2)->text().toDouble();
    }
    Matrix2D Matrix_C(3,3);
    Matrix_C = Matrix_A * Matrix_B;

    for(int i=0; i<3; i++){
        ui->tableWidget_MatrixC->setItem(i,0,new QTableWidgetItem(QString::number(Matrix_C.Get(i,0))));
        ui->tableWidget_MatrixC->setItem(i,1,new QTableWidgetItem(QString::number(Matrix_C.Get(i,1))));
        ui->tableWidget_MatrixC->setItem(i,2,new QTableWidgetItem(QString::number(Matrix_C.Get(i,2))));
    }
}
//====================================================================//
//                       A  =C                       //
//====================================================================//
void Dialog::on_pushButton_Transp_clicked()
{
    Matrix2D Matrix_A(3,3);
    for(int i=0; i<3; i++){
        Matrix_A(i, 0) = ui->tableWidget_MatrixA->item(i,0)->text().toDouble();
        Matrix_A(i, 1) = ui->tableWidget_MatrixA->item(i,1)->text().toDouble();
        Matrix_A(i, 2) = ui->tableWidget_MatrixA->item(i,2)->text().toDouble();
    }

    Matrix2D Matrix_C(3,3);
    Matrix_C = Matrix_A.Transpose();

    for(int i=0; i<3; i++){
        ui->tableWidget_MatrixC->setItem(i,0,new QTableWidgetItem(QString::number(Matrix_C.Get(i,0))));
        ui->tableWidget_MatrixC->setItem(i,1,new QTableWidgetItem(QString::number(Matrix_C.Get(i,1))));
        ui->tableWidget_MatrixC->setItem(i,2,new QTableWidgetItem(QString::number(Matrix_C.Get(i,2))));
    }
}
//====================================================================//
//                            A  =C                           //
//====================================================================//
void Dialog::on_pushButton_Invers_clicked()
{
    Matrix2D Matrix_A(3,3);
    for(int i=0; i<3; i++){
        Matrix_A(i, 0) = ui->tableWidget_MatrixA->item(i,0)->text().toDouble();
        Matrix_A(i, 1) = ui->tableWidget_MatrixA->item(i,1)->text().toDouble();
        Matrix_A(i, 2) = ui->tableWidget_MatrixA->item(i,2)->text().toDouble();
    }

    Matrix2D Matrix_C(3,3);
    Matrix_C = Matrix_A.Inverse();

    for(int i=0; i<3; i++){
        ui->tableWidget_MatrixC->setItem(i,0,new QTableWidgetItem(QString::number(Matrix_C.Get(i,0))));
        ui->tableWidget_MatrixC->setItem(i,1,new QTableWidgetItem(QString::number(Matrix_C.Get(i,1))));
        ui->tableWidget_MatrixC->setItem(i,2,new QTableWidgetItem(QString::number(Matrix_C.Get(i,2))));
    }
}
