#pragma once

#include <exception>
#include <iostream>

struct Size2D {
	Size2D(int W, int H) {
		Width=W;
		Height=H;
	}
	int Width;
	int Height;
};

enum MathExceptions {
	ME_MatrixEmpty	=0		,
	ME_OutOfBounds			,
	ME_MatrixSizeNotEqual	,
	ME_RowColumnMissMatch	,
	ME_MatrixNotSquare		,
	ME_SizeNotEqualOrGreat	,
	ME_InexistantColumn		,
	ME_InexistantRow
};

const char *ErrorTexts[] = { "Matrix is empty",
							 "Out of bounds",
							 "Size of matrices should be same", 
							 "Col num of 1st matrix and Row num of 2nd matrix must be equal",
							 "The row and column number of matrix should be equal",
							 "The size of matrix should be equal or greater than the copied matrix",
							 "Referenced column does not exist",
							 "Referenced row does not exist",
};

class MathException : public std::exception {
public:

	MathException(MathExceptions code) {
		this->Code=code;
	}

	virtual const char* what() const throw() {
		return ErrorTexts[(int)Code];
	}

	MathExceptions GetErrorCode() { return Code; }


protected:
	MathExceptions Code;
};

std::ostream &operator << (std::ostream &out, MathException &exception) {
	out<<"Error #"<<(int)exception.GetErrorCode()<<" "<<exception.what()<<std::endl;

	return out;
}
