#pragma once

#include "MathLibrary.h"
#include "assert.h"
#include <iostream>

template <class _T>
class ManagedBuffer {
public:
	ManagedBuffer() {
		refcnt=new int[1];
		*refcnt=1;
		data=NULL;
		size=0;
	}

	ManagedBuffer(int size) {
		refcnt=new int[1];
		*refcnt=1;
		data=NULL;
		Resize(size);
	}

	ManagedBuffer(ManagedBuffer &buf) {
		data=buf.data;
		refcnt=buf.refcnt;
		size=buf.size;
	}

	void Resize(int size) {
		if(data)
			data=(_T*) realloc(data, size*sizeof(_T));
		else {
			data=(_T*) malloc(size*sizeof(_T));
		}

		this->size=size;
	}

	inline _T *GetBuffer() {
#ifdef _DEBUG
		if(data==NULL) {
			DisplayMessage("Managed Buffer", "Data is not set");
			assert(0);
		}
#endif

		return data;
	}

	void AddReference() {
		(*refcnt)++;
	}

	int GetSize() {
		return size;
	}

	void RemoveReference()
	{
		if(*refcnt>0)
			(*refcnt)--;

		if(*refcnt==0 && data) {
			free(data);
			data=NULL;
			size=0;
		}
	}
	~ManagedBuffer() {
		RemoveReference();
	}

	ManagedBuffer<_T> &operator ++() {
		AddReference();

		return *this;
	}

	ManagedBuffer<_T> &operator --() {
		RemoveReference();

		return *this;
	}

	inline _T &operator [] (int index) {
#ifdef _DEBUG
		if(index<0 || index>=size) {
			//cout<<"Index out of bounds";
			assert(0);
		}
#endif

		return data[index];
	}
	operator _T*() {
#ifdef _DEBUG
		if(data==NULL) {
			DisplayMessage("Managed Buffer", "Data is not set");
			assert(0);
		}
#endif
		return data;
	}


private:
	_T *data;
	int size;

	////Reference count
	int *refcnt;
};

