#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui>

#include "function.h"

class Rightlayout: public QVBoxLayout
{

    public:
    QSize maximumSize() const;
};

class Mainwindow : public QMainWindow
{
    Q_OBJECT

public:
    Mainwindow();

private slots:
    void Reset();
    void RefreshGraph();

    void resizeEvent(QResizeEvent *);

signals:
    void Resized();

private:
    void CreateActions();
    void CreateMenus();
    void CreateToolBars();
    void CreateWidgets();
    void ArrangementWidgets();

    QGraphicsScene* Graph;
    QGraphicsView* GraphView;

    QWidget* WorkSpace;
    QToolBar* ToolBar;

    QMenu* FileMenu;
    QMenu* HelpMenu;    

    QAction* ActionExit;
    QAction* ActionAbout;
    QAction* ActionAboutQt;

    QHBoxLayout* MainLayout;
    Rightlayout* RightLayout;

    QLineEdit* EditFrom;
    QLineEdit* EditTo;

    QComboBox* ComboBoxScale;

    QCheckBox* CheckBoxFunc1;
    QCheckBox* CheckBoxFunc2;
    QCheckBox* CheckBoxFunc3;
    QCheckBox* CheckBoxFunc4;
    QCheckBox* CheckBoxFunc5;

    QCheckBox* CheckBoxCross;

    QLabel* LabelShow;
    QLabel* LabelFrom;
    QLabel* LabelTo;
    QLabel* LabelScale;
};

#endif // MAINWINDOW_H
