#include "mainwindow.h"

QSize Rightlayout::maximumSize() const
{
    return QSize(150, 300);
}

Mainwindow::Mainwindow()
{
    this->setWindowTitle("Graph viewer by greh");
    this->setSizeIncrement(5,4);

    CreateActions();
    CreateMenus();
    CreateToolBars();
    CreateWidgets();
    ArrangementWidgets();

    this->setCentralWidget(WorkSpace); 

    connect(this,SIGNAL(Resized()),this,SLOT(RefreshGraph()));
}

void Mainwindow::CreateActions()
{
    ActionAbout=new QAction(tr("About"),this);
    ActionAboutQt=new QAction(tr("AboutQt"),this);
    connect(ActionAboutQt,SIGNAL(triggered()),qApp,SLOT(aboutQt()));
    ActionExit=new QAction(tr("Exit"),this);
    ActionExit->setShortcut(tr("Ctrl+Q"));
    connect(ActionExit,SIGNAL(triggered()),this,SLOT(close()));
}

void Mainwindow::CreateMenus()
{
    FileMenu=menuBar()->addMenu(tr("File"));
    FileMenu->addAction(ActionExit);

    HelpMenu=menuBar()->addMenu(tr("Help"));
    HelpMenu->addAction(ActionAbout);
    HelpMenu->addAction(ActionAboutQt);
}

void Mainwindow::CreateToolBars()
{
    ToolBar=new QToolBar(tr("Actions"));
    this->addToolBar(ToolBar);
}

void Mainwindow::CreateWidgets()
{
    Graph=new QGraphicsScene();
    WorkSpace=new QWidget();
    LabelShow=new QLabel(tr("<center>Show Graph</center>"));
    EditFrom=new QLineEdit("-2");
    connect(EditFrom,SIGNAL(textChanged(QString)),this,SLOT(RefreshGraph()));
    EditTo=new QLineEdit("2");
    connect(EditTo,SIGNAL(textChanged(QString)),this,SLOT(RefreshGraph()));
    LabelFrom=new QLabel(tr("<center>From:</center>"));
    LabelTo=new QLabel(tr("<center>To:</center>"));
    LabelScale=new QLabel(tr("<center>With Scale:</center>"));
    ComboBoxScale=new QComboBox();
    ComboBoxScale->addItem(QString(tr("1 to 2")));
    ComboBoxScale->addItem(QString(tr("1 to 1")));
    ComboBoxScale->addItem(QString(tr("2 to 1")));
    ComboBoxScale->setCurrentIndex(1);
    connect(ComboBoxScale,SIGNAL(currentIndexChanged(int)),this,SLOT(RefreshGraph()));
    CheckBoxFunc1=new QCheckBox(tr("Add Function y=x^2"));
    connect(CheckBoxFunc1,SIGNAL(clicked()),this,SLOT(RefreshGraph()));
    CheckBoxFunc2=new QCheckBox(tr("Add Function y=sin(x)"));
    connect(CheckBoxFunc2,SIGNAL(clicked()),this,SLOT(RefreshGraph()));
    CheckBoxFunc3=new QCheckBox(tr("Add Function y=x^1/2"));
    connect(CheckBoxFunc3,SIGNAL(clicked()),this,SLOT(RefreshGraph()));
    CheckBoxFunc4=new QCheckBox(tr("Add Function y=2*x"));
    connect(CheckBoxFunc4,SIGNAL(clicked()),this,SLOT(RefreshGraph()));
    CheckBoxFunc5=new QCheckBox(tr("Add Function y=2^x"));
    connect(CheckBoxFunc5,SIGNAL(clicked()),this,SLOT(RefreshGraph()));
    CheckBoxCross=new QCheckBox(tr("Find the intersection \n points of functions?"));
    connect(CheckBoxCross,SIGNAL(clicked()),this,SLOT(RefreshGraph()));
}

void Mainwindow::ArrangementWidgets()
{
    MainLayout=new QHBoxLayout();
    RightLayout=new Rightlayout();
    RightLayout->addWidget(LabelShow);
    RightLayout->addWidget(LabelFrom);
    RightLayout->addWidget(EditFrom);
    RightLayout->addWidget(LabelTo);
    RightLayout->addWidget(EditTo);
    RightLayout->addWidget(LabelScale);
    RightLayout->addWidget(ComboBoxScale);
    RightLayout->addWidget(CheckBoxFunc1);
    RightLayout->addWidget(CheckBoxFunc2);
    RightLayout->addWidget(CheckBoxFunc3);
    RightLayout->addWidget(CheckBoxFunc4);
    RightLayout->addWidget(CheckBoxFunc5);
    RightLayout->addWidget(CheckBoxCross);
    RightLayout->addStretch(20);
    GraphView=new QGraphicsView(Graph);
    MainLayout->addWidget(GraphView);
    MainLayout->addLayout(RightLayout);
    WorkSpace->setLayout(MainLayout);
    GraphView->setMinimumSize(450,450);
    GraphView->setSizeIncrement(4,4);
    GraphView->resize(450,450);
}

void Mainwindow::Reset()
{
}

void Mainwindow::RefreshGraph()
{
    Graph->clear();
    const int height=GraphView->height(),width=GraphView->width();
    int step=20;

    switch (ComboBoxScale->currentIndex())
    {
    case 0:
        step=10;
        break;
    case 1:
        step=20;
        break;
    case 2:
        step=40;
        break;
}
    Graph->setBackgroundBrush(Qt::white);

    Graph->addLine(0,(-height+50)/2,0,(height-50)/2,QPen(Qt::black,2)); //  y
    //Graph->addLine(0,(-height+50)/2,-10,(-height+50)/2+20,QPen(Qt::black,2)); //  /         /**/
    //Graph->addLine(0,(-height+50)/2,+10,(-height+50)/2+20,QPen(Qt::black,2)); //    \       /**/

    Graph->addLine((-width+50)/2,0,(width-50)/2,0,QPen(Qt::black,2));   //  x
    //Graph->addLine((width-50)/2,0,(width-50)/2-20,-10,QPen(Qt::black,2)); //    \           /**/
    //Graph->addLine((width-50)/2,0,(width-50)/2-20,+10,QPen(Qt::black,2)); //  /             /**/

    int i=(-height+50)/2-step;

    do
    {
        Graph->addLine((-width+50)/2,i+20,(width-50)/2,i+20,QPen(Qt::gray,1)); //   horizontal lines
        i+=step;
    }
    while(i<(height-50)/2);

    int i2=(-width+50)/2-step;

    do
    {
        Graph->addLine(i2+step,(-height+50)/2,i2+step,(height-50)/2,QPen(Qt::gray,1)); //   vertical lines
        i2+=step;
    }
    while(i2<(width-50)/2);

    bool SelectedFunction[5];

    SelectedFunction[0]=CheckBoxFunc1->isChecked();
    SelectedFunction[1]=CheckBoxFunc2->isChecked();
    SelectedFunction[2]=CheckBoxFunc3->isChecked();
    SelectedFunction[3]=CheckBoxFunc4->isChecked();
    SelectedFunction[4]=CheckBoxFunc5->isChecked();

    Point2D PointPrev,PointNext;

    Function FuncArray[5];

    int From=EditFrom->text().toInt(),To=EditTo->text().toInt();


    for(int funcIndex=0;funcIndex<5;funcIndex++)
    {
        FuncArray[funcIndex].SetType(funcIndex);
        if(SelectedFunction[funcIndex])
        {
            for(int i=From;i<To;i++)
            {
                PointPrev=FuncArray[funcIndex].GetPointByX(i);
                PointNext=FuncArray[funcIndex].GetPointByX(i+1);
                Graph->addLine(PointPrev.GetX()*step,-PointPrev.GetY()*step,PointNext.GetX()*step,-PointNext.GetY()*step,QPen(Qt::black,2));
                Graph->addEllipse(PointPrev.GetX()*step-2,-PointPrev.GetY()*step-5,5,5,QPen(Qt::red,1),QBrush(Qt::red));
                Graph->addEllipse(PointNext.GetX()*step-2,-PointNext.GetY()*step-5,5,5,QPen(Qt::red,1),QBrush(Qt::red));

            }
        }
    }



}

void Mainwindow::resizeEvent(QResizeEvent *)
{
    emit Resized();
}
